<?php
/**
 * Plugin Name: Stock Exchange Releases
 * Plugin URI: https://github.com/mintmedias/
 * Description: This plugin imports posts from the cision api.
 * Version: 1.0.1
 * Author: Kasper Aamodt
 * Author URI: https://aamodtgroup.com
 * Text Domain: stock-exchange-releases
 * Domain Path: /languages
 *
 *
 */

function get_posts_from_cision() {
    require_once( ABSPATH . "wp-includes/pluggable.php" );
    include('auth.php');

    $ids = "https://publish.ne.cision.com/papi/NewsFeed/{$auth}?format=json";

    $curl = curl_init($ids);
    curl_setopt($curl, CURLOPT_URL, $ids);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

    $resp = curl_exec($curl);
    curl_close($curl);

    $obj = json_decode($resp);
    $array = (array) $obj->Releases;

    foreach ($array as $key=>$ids) {
        $url = "https://publish.ne.cision.com/papi/Release/{$ids->EncryptedId}?format=json";
        $req = curl_init($url);
        curl_setopt($req, CURLOPT_URL, $url);
        curl_setopt($req, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($req);
        curl_close($req);
        $decoded = json_decode($response);
        $data = $decoded->Release;
        $status = get_post_status($data->Id);
        $files = $data->Files;
        $attatchments = '<h3>Documents & Links</h3>';
        foreach ($files as $file) {
            $attatchments .= '<a href="' . $file->Url . '" target="_blank">' . $file->Title .'</a><br>';
        };
        $content = $data->HtmlIntro . $data->HtmlBody . $data->HtmlContact . $data->HtmlCompanyInformation;
        $new_content = strip_tags($content, '<p><a><ul><li>') . $attatchments;
        if (!$status) {
            $post = array(
                'import_id' => $data->Id,
                'post_type'=> 'ser',
                'post_title' => $data->Title,
                'post_content' => $new_content,
                'post_date' => $data->PublishDate,
                'post_status' => 'publish',
            );
            $post_id = wp_insert_post($post);
        } else {
            $post = array(
                'ID' => $data->Id,
                'post_type'=> 'ser',
                'post_title' => $data->Title,
                'post_content' => $new_content,
                'post_date' => $data->PublishDate,
                'post_status' => 'publish',
            );
            $post_id = wp_insert_post($post);
        }
    }

}

add_action( 'ag_cron_hook', 'get_posts_from_cision' );

if ( ! wp_next_scheduled( 'ag_cron_hook' ) ) {
    wp_schedule_event( time(), 'hourly', 'ag_cron_hook' );
};

?>