<?php

function mab_register_acf_block_types() {
    acf_register_block_type( [
        'name'            => 'post-grid',
        'title'           => __( 'Post grid' ),
        'description'     => __( 'Post grid block.' ),
        'render_template' => dirname( __FILE__ ) . '/blocks/post-grid/post-grid.php',
        'enqueue_style'   => plugin_dir_url( __FILE__ ) . '/blocks/post-grid/dist/style.css',
        'category'        => 'agtech',
        'icon'            => file_get_contents( plugin_dir_url( __FILE__ ) . '/icons/grid.svg' ),
        'supports'        => array(
            'mode'          => false,
        )
    ] );
    include_once dirname( __FILE__ ) . '/blocks/post-grid/post-type.php';
    include dirname( __FILE__ ) . '/blocks/post-grid/acf-fields.php';
    acf_register_block_type( [
        'name'            => 'ser',
        'title'           => __( 'Stock exchange releases' ),
        'description'     => __( 'Stock exchange releases.' ),
        'render_template' => dirname( __FILE__ ) . '/blocks/ser/ser.php',
        //'enqueue_style'   => plugin_dir_url( __FILE__ ) . '/blocks/ser/dist/style.css',
        'category'        => 'agtech',
        'icon'            => file_get_contents( plugin_dir_url( __FILE__ ) . '/icons/grid.svg' ),
        'supports'        => array(
            'mode'          => false,
        )
    ] );
    acf_register_block_type( [
        'name'            => 'events',
        'title'           => __( 'Events' ),
        'description'     => __( 'Events block.' ),
        'render_template' => dirname( __FILE__ ) . '/blocks/events/events.php',
        'enqueue_style'   => plugin_dir_url( __FILE__ ) . '/blocks/events/style.css',
        'category'        => 'agtech',
        'icon'            => file_get_contents( plugin_dir_url( __FILE__ ) . '/icons/grid.svg' ),
        'supports'        => array(
            'mode'          => false,
        )
    ] );
    acf_register_block_type( [
        'name'            => 'events-test',
        'title'           => __( 'Events test' ),
        'description'     => __( 'Events block.' ),
        'render_template' => dirname( __FILE__ ) . '/blocks/events-test/events.php',
        'category'        => 'agtech',
        'icon'            => file_get_contents( plugin_dir_url( __FILE__ ) . '/icons/grid.svg' ),
        'supports'        => array(
            'mode'          => false,
        )
    ] );
    acf_register_block_type( [
        'name'            => 'newsletter',
        'title'           => __( 'Newsletter' ),
        'description'     => __( 'Newsletter block.' ),
        'render_template' => dirname( __FILE__ ) . '/blocks/newsletter/newsletter.php',
        'category'        => 'agtech',
        'icon'            => file_get_contents( plugin_dir_url( __FILE__ ) . '/icons/newsletter.svg' ),
        'supports'        => array(
            'mode'          => false,
        )
    ] );
    acf_register_block_type( [
        'name'            => 'filedownload',
        'title'           => __( 'File download' ),
        'description'     => __( 'File download block.' ),
        'render_template' => dirname( __FILE__ ) . '/blocks/filedownload/filedownload.php',
        'category'        => 'agtech',
        'icon'            => file_get_contents( plugin_dir_url( __FILE__ ) . '/icons/grid.svg' ),
        'supports'        => array(
            'mode'          => false,
        )
    ] );
    include dirname( __FILE__ ) . '/blocks/filedownload/acf-fields.php';
}

if ( function_exists( 'acf_register_block_type' ) ) {
    add_action( 'acf/init', 'mab_register_acf_block_types' );
}

?>