<?php

// Create class attribute allowing for custom "className" and "align" values.
$className = 'orders';
if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
}
if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
}

$args = array(
    'post_type' => 'ser',
    'posts_per_page' => -1,
);

$new_query = new WP_Query($args);

?>

<div class="<?php echo esc_attr($className); ?>">
    <?php while($new_query->have_posts()) : $new_query->the_post(); ?>
        <div class="ser-div">
            <a href="<?php the_permalink(); ?>">
                <p class="ser-date">
                    <?php the_date(); ?>
                </p>
                <h2 class="ser-title">
                    <?php the_title(); ?>
                </h2>
            </a>
        </div>
    <?php endwhile; ?>
    <?php wp_reset_postdata(); // reset the query ?>
</div>
