<?php

// Create id attribute allowing for custom "anchor" value.
$id = 'post-grid-' . $block['id'];
if ( ! empty( $block['anchor'] ) ) {
    $id = $block['anchor'];
}

// Create class attribute allowing for custom "className" and "align" values.
$align_class = $block['align'] ? 'align' . $block['align'] : ''; 
$class_name = isset($block['className']) ? $class_name : "";
?>

<section id="post-grid" class="<?php echo $class_name . $align_class; ?>">

    <?php
    $featured_posts = get_field('featured_posts');
    $post_type_acf = get_field('post_type');
    $number_of_posts = get_field('number_of_posts');
    ?>

    <div class="ag-grid">
    <?php

    if ( $featured_posts ) {
        $args = array
        (
        'post_type' => 'any',
        'post__in' => $featured_posts,
        );
    } else {
        $args = array
        (
        'post_type' => $post_type_acf,
        'posts_per_page' => $number_of_posts,
        );
    }

    $new_query = new WP_Query($args);
    while($new_query->have_posts()) : $new_query->the_post(); ?>

        <div class="ag-card" id="post-<?php the_ID(); ?>">
            <div class="ag-image">
                <a href="<?php the_permalink(); ?>">
                    <img src="<?php the_post_thumbnail_url(); ?>">
                </a>
            </div>
            <a href="<?php the_permalink(); ?>" class="ag-title">
                <h2><?php the_title(); ?></h2>
            </a>
        </div>

    <?php endwhile; ?>
    <?php wp_reset_postdata(); // reset the query ?>
    </div>

</section>