<?php

// Create id attribute allowing for custom "anchor" value.
$id = 'event-' . $block['id'];
if ( ! empty( $block['anchor'] ) ) {
    $id = $block['anchor'];
}

// Create class attribute allowing for custom "className" and "align" values.
$align_class = $block['align'] ? 'align' . $block['align'] : ''; 
$class_name = isset($block['className']) ? $class_name : "";
?>

<section id="<?php echo $id; ?>" class="<?php echo $class_name . $align_class; ?>">

    <?php

    $args = array (
        'post_type' => 'events',
        'numberposts' => -1
    );


    $the_query = new WP_Query($args);
    while($the_query->have_posts()) : $the_query->the_post(); ?>

        <div class="event-card" id="post-<?php the_ID(); ?>">
            <a href="<?php the_permalink(); ?>">
                <p class="event-date"><?php the_field("event_date"); ?></p>
                <h2 class="event-title"><?php the_title(); ?></h2>
            </a>
        </div>

    <?php endwhile; ?>
    <?php wp_reset_postdata(); // reset the query ?>

</section>