<?php
/**
 * Plugin Name:     AG Tech - CPT
 * Plugin URI:      https://aamodtgroup.com/
 * Description:     Custom post types setup for websites
 * Author:          Kasper Aamodt
 * Author URI:      https://aamodt.xyz/
 * Text Domain:     agtech
 * Version:         1.0.0
 *
 */

function my_custom_post_people() {
  $labels = array(
    'name'               => _x( 'People', 'post type general name' ),
    'singular_name'      => _x( 'People', 'post type singular name' ), 
    'menu_name'          => 'People'
  );
  $args = array(
    'labels'        => $labels,
    'description'   => 'Services your company offer',
    'menu_icon'     => 'dashicons-products',
    'public'        => true,
    'supports'      => array( 'title', 'editor', 'thumbnail', 'excerpt', 'featured image', 'author' ),
    'show_in_rest'  => true,
    'has_archive'   => true,
  );
  register_post_type( 'people', $args ); 
}
add_action( 'init', 'my_custom_post_people' );

function my_custom_post_esg() {
  $labels = array(
    'name'               => _x( 'ESG', 'post type general name' ),
    'singular_name'      => _x( 'ESG', 'post type singular name' ), 
    'menu_name'          => 'ESG'
  );
  $args = array(
    'labels'        => $labels,
    'description'   => 'Services your company offer',
    'menu_icon'     => 'dashicons-products',
    'public'        => true,
    'supports'      => array( 'title', 'editor', 'thumbnail', 'excerpt', 'featured image', 'author' ),
    'show_in_rest'  => true,
    'has_archive'   => true,
  );
  register_post_type( 'esg', $args ); 
}
add_action( 'init', 'my_custom_post_esg' );


function my_custom_post_board() {
  $labels = array(
    'name'               => _x( 'Board', 'post type general name' ),
    'singular_name'      => _x( 'Board', 'post type singular name' ), 
    'menu_name'          => 'Board'
  );
  $args = array(
    'labels'        => $labels,
    'description'   => 'Services your company offer',
    'menu_icon'     => 'dashicons-products',
    'public'        => true,
    'supports'      => array( 'title', 'editor', 'thumbnail', 'excerpt', 'featured image', 'author' ),
    'show_in_rest'  => true,
    'has_archive'   => true,
  );
  register_post_type( 'board', $args ); 
}
add_action( 'init', 'my_custom_post_board' );

function my_custom_post_investors() {
  $labels = array(
    'name'               => _x( 'Investors', 'post type general name' ),
    'singular_name'      => _x( 'Investors', 'post type singular name' ), 
    'menu_name'          => 'Investors'
  );
  $args = array(
    'labels'        => $labels,
    'description'   => 'Services your company offer',
    'menu_icon'     => 'dashicons-products',
    'public'        => true,
    'supports'      => array( 'title', 'editor', 'thumbnail', 'excerpt', 'featured image', 'author' ),
    'show_in_rest'  => true,
    'has_archive'   => true,
  );
  register_post_type( 'investors', $args ); 
}
add_action( 'init', 'my_custom_post_investors' );

function my_custom_post_news() {
  $labels = array(
    'name'               => _x( 'News', 'post type general name' ),
    'singular_name'      => _x( 'News', 'post type singular name' ), 
    'menu_name'          => 'News'
  );
  $args = array(
    'labels'        => $labels,
    'description'   => 'News',
    'menu_icon'     => 'dashicons-products',
    'public'        => true,
    'supports'      => array( 'title', 'editor', 'thumbnail', 'excerpt', 'featured image', 'author' ),
    'taxonomies'    => array('category' ),
    'show_in_rest'  => true,
    'has_archive'   => true,
  );
  register_post_type( 'news', $args ); 
}
add_action( 'init', 'my_custom_post_news' );

function my_custom_post_events() {
  $labels = array(
    'name'               => _x( 'Events', 'post type general name' ),
    'singular_name'      => _x( 'Event', 'post type singular name' ), 
    'menu_name'          => 'Events'
  );
  $args = array(
    'labels'        => $labels,
    'description'   => 'Events',
    'menu_icon'     => 'dashicons-products',
    'public'        => true,
    'supports'      => array( 'title', 'editor', 'thumbnail', 'excerpt', 'featured image', 'author' ),
    'show_in_rest'  => true,
    'has_archive'   => true,
  );
  register_post_type( 'events', $args ); 
}
add_action( 'init', 'my_custom_post_events' );

function my_custom_post_ser() {
  $labels = array(
    'name'               => _x( 'SER', 'post type general name' ),
    'singular_name'      => _x( 'SER', 'post type singular name' ), 
    'menu_name'          => 'SER'
  );
  $args = array(
    'labels'        => $labels,
    'description'   => 'SER',
    'menu_icon'     => 'dashicons-products',
    'public'        => true,
    'supports'      => array( 'title', 'editor', 'thumbnail', 'excerpt', 'featured image', 'author' ),
    'show_in_rest'  => true,
    'has_archive'   => true,
  );
  register_post_type( 'ser', $args ); 
}
add_action( 'init', 'my_custom_post_ser' );

function my_taxonomies_general() {
  $labels = array(
    'name'              => _x( 'Tagger', 'taxonomy general name' ),
    'singular_name'     => _x( 'Tag', 'taxonomy singular name' ),
    'menu_name'         => __( 'Tagger' ),
  );
  $args = array(
    'labels' => $labels,
    'hierarchical' => true,
  );
  register_taxonomy( 'tagger', array('tjenester', 'kundecaser', 'nyheter'), $args );
}
add_action( 'init', 'my_taxonomies_general', 0 );